"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTranslation = getTranslation;
const fs = require("fs");
const path = require("path");
const localesCache = {};
function getTranslation(key, lang = 'en', module = 'common') {
    const localeKey = `${module}.${lang}`;
    if (!localesCache[localeKey]) {
        try {
            const filePath = path.join(__dirname, 'locales', `${module}.${lang}.json`);
            if (fs.existsSync(filePath)) {
                const content = fs.readFileSync(filePath, 'utf-8');
                localesCache[localeKey] = JSON.parse(content);
            }
            else {
                localesCache[localeKey] = {};
            }
        }
        catch (error) {
            console.error(`Error loading locale file: ${error}`);
            localesCache[localeKey] = {};
        }
    }
    return localesCache[localeKey][key] || key;
}
//# sourceMappingURL=translation.util.js.map