"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SmsService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmsService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
let SmsService = SmsService_1 = class SmsService {
    constructor(config) {
        this.config = config;
        this.logger = new common_1.Logger(SmsService_1.name);
    }
    async sendSms(phone, message) {
        try {
            const provider = this.config.get('SMS_PROVIDER') || 'console';
            switch (provider) {
                case 'kavenegar':
                    return await this.sendViaKavenegar(phone, message);
                case 'farapayamak':
                    return await this.sendViaFarapayamak(phone, message);
                case 'twilio':
                    return await this.sendViaTwilio(phone, message);
                default:
                    this.logger.log(`[SMS] To: ${phone} | Message: ${message}`);
                    return true;
            }
        }
        catch (error) {
            this.logger.error(`Failed to send SMS to ${phone}: ${error.message}`);
            return false;
        }
    }
    async sendOtp(phone, code) {
        const message = `کد تایید شما: ${code}\nاعتبار: 5 دقیقه`;
        return this.sendSms(phone, message);
    }
    async sendViaKavenegar(phone, message) {
        const apiKey = this.config.get('KAVENEGAR_API_KEY');
        if (!apiKey) {
            this.logger.warn('KAVENEGAR_API_KEY not configured');
            return false;
        }
        try {
            const response = await fetch(`https://api.kavenegar.com/v1/${apiKey}/sms/send.json`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    receptor: phone,
                    message: message,
                }),
            });
            const data = await response.json();
            if (data.return.status === 200) {
                this.logger.log(`SMS sent via Kavenegar to ${phone}`);
                return true;
            }
            throw new Error(data.return.message);
        }
        catch (error) {
            this.logger.error(`Kavenegar error: ${error.message}`);
            return false;
        }
    }
    async sendViaFarapayamak(phone, message) {
        const username = this.config.get('FARAPAYAMAK_USERNAME');
        const password = this.config.get('FARAPAYAMAK_PASSWORD');
        const fromNumber = this.config.get('FARAPAYAMAK_FROM');
        if (!username || !password || !fromNumber) {
            this.logger.warn('Farapayamak credentials not configured');
            return false;
        }
        try {
            const response = await fetch('https://rest.payamak-panel.com/api/SendSMS/SendSMS', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    username: username,
                    password: password,
                    to: phone,
                    from: fromNumber,
                    text: message + "\n\n" + "https://vitai.ir" + "\n\n" + "لغو11",
                    isflash: false,
                }),
            });
            const data = await response.json();
            if (data.RetStatus === 1 || response.ok) {
                this.logger.log(`SMS sent via Farapayamak to ${phone}`);
                return true;
            }
            throw new Error(data.StrRetStatus || 'Unknown error');
        }
        catch (error) {
            this.logger.error(`Farapayamak error: ${error.message}`);
            return false;
        }
    }
    async sendViaTwilio(phone, message) {
        const accountSid = this.config.get('TWILIO_ACCOUNT_SID');
        const authToken = this.config.get('TWILIO_AUTH_TOKEN');
        const fromNumber = this.config.get('TWILIO_PHONE_NUMBER');
        if (!accountSid || !authToken || !fromNumber) {
            this.logger.warn('Twilio credentials not configured');
            return false;
        }
        try {
            const auth = Buffer.from(`${accountSid}:${authToken}`).toString('base64');
            const response = await fetch(`https://api.twilio.com/2010-04-01/Accounts/${accountSid}/Messages.json`, {
                method: 'POST',
                headers: {
                    'Authorization': `Basic ${auth}`,
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    To: phone,
                    From: fromNumber,
                    Body: message,
                }),
            });
            if (response.ok) {
                this.logger.log(`SMS sent via Twilio to ${phone}`);
                return true;
            }
            const error = await response.json();
            throw new Error(error.message);
        }
        catch (error) {
            this.logger.error(`Twilio error: ${error.message}`);
            return false;
        }
    }
};
exports.SmsService = SmsService;
exports.SmsService = SmsService = SmsService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], SmsService);
//# sourceMappingURL=sms.service.js.map