"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalizeDigits = normalizeDigits;
function normalizeDigits(input) {
    if (!input || typeof input !== 'string')
        return input;
    const persianDigits = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    const arabicDigits = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    const englishDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    let output = input;
    persianDigits.forEach((digit, index) => {
        output = output.replace(new RegExp(digit, 'g'), englishDigits[index]);
    });
    arabicDigits.forEach((digit, index) => {
        output = output.replace(new RegExp(digit, 'g'), englishDigits[index]);
    });
    return output;
}
//# sourceMappingURL=normalize-digits.js.map