"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
const common_1 = require("@nestjs/common");
const winston = require("winston");
class Logger extends common_1.ConsoleLogger {
    constructor() {
        super();
        this.logger = winston.createLogger({
            level: 'info',
            format: winston.format.combine(winston.format.timestamp(), winston.format.json()),
            transports: [
                new winston.transports.File({ filename: 'logs/error.log', level: 'error' }),
                new winston.transports.File({ filename: 'logs/combined.log' }),
                new winston.transports.Console(),
            ],
        });
    }
    log(message) {
        this.logger.info(message);
        super.log(message);
    }
    error(message, trace) {
        this.logger.error(message);
        super.error(message, trace);
    }
    warn(message) {
        this.logger.warn(message);
        super.warn(message);
    }
}
exports.Logger = Logger;
//# sourceMappingURL=logger.js.map