"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailService = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const nodemailer = require("nodemailer");
const fs = require("fs");
const path = require("path");
let EmailService = class EmailService {
    constructor(config) {
        this.config = config;
        this.locales = new Map();
        const provider = (process.env.EMAIL_PROVIDER || this.config.get('EMAIL_PROVIDER') || 'smtp').toString().toLowerCase();
        if (provider === 'console') {
            this.transporter = null;
        }
        else if (provider === 'sendgrid') {
            this.transporter = nodemailer.createTransport({
                host: process.env.SENDGRID_SMTP_HOST || this.config.get('SENDGRID_SMTP_HOST') || 'smtp.sendgrid.net',
                port: parseInt(process.env.SENDGRID_SMTP_PORT || this.config.get('SENDGRID_SMTP_PORT') || '587', 10),
                secure: false,
                auth: {
                    user: process.env.SENDGRID_USER || this.config.get('SENDGRID_USER') || 'apikey',
                    pass: process.env.SENDGRID_API_KEY || this.config.get('SENDGRID_API_KEY'),
                },
            });
        }
        else {
            const host = process.env.APP_SMTP_HOST || this.config.get('APP_SMTP_HOST') || 'vitai.ir';
            const port = parseInt(process.env.APP_SMTP_PORT || this.config.get('APP_SMTP_PORT') || '465', 10);
            const secureEnv = process.env.APP_SMTP_SECURE || this.config.get('APP_SMTP_SECURE');
            const secure = secureEnv !== undefined ? secureEnv === 'true' : port === 465;
            const user = process.env.APP_EMAIL_USER || this.config.get('APP_EMAIL_USER') || process.env.APP_SMTP_USER || this.config.get('APP_SMTP_USER');
            const pass = process.env.APP_EMAIL_PASSWORD || this.config.get('APP_EMAIL_PASSWORD') || process.env.APP_SMTP_PASS || this.config.get('APP_SMTP_PASS');
            this.transporter = nodemailer.createTransport({
                host,
                port,
                secure,
                auth: { user, pass },
                tls: { rejectUnauthorized: false },
            });
        }
        this.loadLocales();
    }
    loadLocales() {
        const localesDir = path.join(__dirname, 'locales');
        const languages = ['fa', 'en', 'ar'];
        languages.forEach((lang) => {
            try {
                const filePath = path.join(localesDir, `email.${lang}.json`);
                const content = fs.readFileSync(filePath, 'utf-8');
                this.locales.set(lang, JSON.parse(content));
            }
            catch (error) {
                console.warn(`Failed to load locale file for ${lang}:`, error.message);
            }
        });
    }
    async sendOtp(email, code, language = 'en') {
        const provider = this.config.get('EMAIL_PROVIDER') || 'console';
        switch (provider.toLowerCase()) {
            case 'smtp':
                await this.sendViaSmtp(email, code, language);
                break;
            case 'sendgrid':
                await this.sendViaSendGrid(email, code, language);
                break;
            case 'console':
            default:
                this.sendViaConsole(email, code, language);
                break;
        }
    }
    sendViaConsole(email, code, language = 'en') {
        const messages = this.getMessages(language);
        console.log(`[EMAIL OTP] To: ${email}, Code: ${code}`);
        console.log(`========================`);
        console.log(messages.verificationCode + ': ' + code);
        console.log(messages.expiryMessage);
        console.log(`========================`);
    }
    async sendViaSmtp(email, code, language = 'en') {
        const htmlTemplate = this.getOtpEmailTemplate(code, language);
        const messages = this.getMessages(language);
        try {
            await this.transporter.sendMail({
                from: `"${this.config.get('APP_NAME', 'vitai')}" <${this.config.get('APP_EMAIL_USER')}>`,
                to: email,
                subject: messages.emailSubject,
                html: htmlTemplate,
            });
            console.log(`[SMTP] OTP email sent successfully to ${email}`);
        }
        catch (error) {
            console.error(`[SMTP] Failed to send email to ${email}:`, error.message);
            this.sendViaConsole(email, code, language);
        }
    }
    async sendEmailViaSmtp(message, to, subject, language) {
        const htmlTemplate = this.emailTemplate(message, language);
        try {
            await this.transporter.sendMail({
                from: `"${this.config.get('APP_NAME', 'vitai')}" <${this.config.get('APP_EMAIL_USER')}>`,
                to: to,
                subject: subject,
                html: htmlTemplate,
            });
            console.log(`[SMTP] OTP email sent successfully to ${to}`);
        }
        catch (error) {
            console.error(`[SMTP] Failed to send email to ${to}:`, error.message);
        }
    }
    getMessages(language) {
        const messages = this.locales.get(language);
        if (messages) {
            return messages;
        }
        return this.locales.get('en') || {
            emailSubject: 'Verification Code - vitai',
            greeting: 'Hello,',
            verificationCode: 'Your verification code is',
            codeLabel: 'Verification Code',
            expiryMessage: 'This code expires in 5 minutes.',
            warningMessage: '⚠️ Do not share this code with anyone.',
            footerMessage: 'This email was sent automatically, please do not reply.',
            emailTitle: '🔐 Verification Code',
        };
    }
    getOtpEmailTemplate(code, language = 'en') {
        const messages = this.getMessages(language);
        const isRtl = ['fa', 'ar', 'ur'].includes(language);
        const dir = isRtl ? 'rtl' : 'ltr';
        const lang = isRtl ? language : 'en';
        return `
      <!DOCTYPE html>
      <html dir="${dir}" lang="${lang}">
      <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>${messages.codeLabel}</title>
        <style>
          body {
            font-family: Tahoma, Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
          }
          .container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
          }
          .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 30px;
            text-align: center;
          }
          .header h1 {
            color: #ffffff;
            margin: 0;
            font-size: 24px;
          }
          .content {
            padding: 40px 30px;
            text-align: center;
          }
          .otp-code {
            background-color: #f8f9fa;
            border: 2px dashed #667eea;
            border-radius: 8px;
            padding: 20px;
            margin: 30px 0;
            font-size: 32px;
            font-weight: bold;
            letter-spacing: 8px;
            color: #667eea;
            font-family: 'Courier New', monospace;
          }
          .message {
            color: #555;
            line-height: 1.8;
            margin: 20px 0;
          }
          .warning {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            text-align: right;
            color: #856404;
          }
          .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #888;
            font-size: 12px;
          }
          .btn {
            display: inline-block;
            padding: 12px 30px;
            background-color: #667eea;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
          }
        </style>
      </head>
      <body>
        <div class="container">
          <div class="header">
            <h1>${messages.emailTitle}</h1>
          </div>
          <div class="content">
            <p class="message">
              ${messages.greeting}<br>
              ${messages.verificationCode}:
            </p>
            <div class="otp-code">
              ${code}
            </div>
            <p class="message">
              ${messages.expiryMessage}
            </p>
            <div class="warning">
              ${messages.warningMessage}
            </div>
          </div>
          <div class="footer">
            <p>${messages.footerMessage}</p>
            <p>© 2025 vitai. All rights reserved.</p>
          </div>
        </div>
      </body>
      </html>
    `;
    }
    emailTemplate(message, language = 'en') {
        const isRtl = ['fa', 'ar', 'ur'].includes(language);
        const dir = isRtl ? 'rtl' : 'ltr';
        const lang = isRtl ? language : 'en';
        return `
      <!DOCTYPE html>
      <html dir="${dir}" lang="${lang}">
      <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
         
        <style>
          body {
            font-family: Tahoma, Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
          }
          .container {
            max-width: 600px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
          }
          .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 30px;
            text-align: center;
          }
          .header h1 {
            color: #ffffff;
            margin: 0;
            font-size: 24px;
          }
          .content {
            padding: 40px 30px;
            text-align: center;
          }
          .otp-code {
            background-color: #f8f9fa;
            border: 2px dashed #667eea;
            border-radius: 8px;
            padding: 20px;
            margin: 30px 0;
            font-size: 32px;
            font-weight: bold;
            letter-spacing: 8px;
            color: #667eea;
            font-family: 'Courier New', monospace;
          }
          .message {
            color: #555;
            line-height: 1.8;
            margin: 20px 0;
          }
          .warning {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            text-align: right;
            color: #856404;
          }
          .footer {
            background-color: #f8f9fa;
            padding: 20px;
            text-align: center;
            color: #888;
            font-size: 12px;
          }
          .btn {
            display: inline-block;
            padding: 12px 30px;
            background-color: #667eea;
            color: #ffffff;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
          }
        </style>
      </head>
      <body>
        <div class="container">
          
          <div class="content">
            <p class="message">
              ${message}<br>
             
            </p>
           
          </div>
          <div class="footer">
            
            <p>© 2025 vitai. All rights reserved.</p>
          </div>
        </div>
      </body>
      </html>
    `;
    }
    async sendViaSendGrid(email, code, language = 'en') {
        console.log(`[SendGrid] Sending OTP ${code} to ${email} in ${language}`);
    }
};
exports.EmailService = EmailService;
exports.EmailService = EmailService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [config_1.ConfigService])
], EmailService);
//# sourceMappingURL=email.service.js.map