"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WelfareService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const category_schema_1 = require("./schemas/category.schema");
const service_schema_1 = require("./schemas/service.schema");
const rating_schema_1 = require("./schemas/rating.schema");
let WelfareService = class WelfareService {
    constructor(categoryModel, serviceModel, ratingModel) {
        this.categoryModel = categoryModel;
        this.serviceModel = serviceModel;
        this.ratingModel = ratingModel;
    }
    async createCategory(createCategoryDto) {
        const category = new this.categoryModel(createCategoryDto);
        return category.save();
    }
    async getAllCategories(includeInactive = false) {
        const filter = includeInactive ? {} : { isActive: true };
        const categories = await this.categoryModel.find(filter).sort({ order: 1 }).exec();
        await Promise.all(categories.map(async (cat) => {
            cat.itemsCount = Number(await this.serviceModel.countDocuments({ categoryId: cat._id + "", isActive: true }));
        }));
        return categories;
    }
    async getCategoryById(id) {
        const category = await this.categoryModel.findById(id).exec();
        if (!category) {
            throw new common_1.NotFoundException('دسته‌بندی یافت نشد');
        }
        return category;
    }
    async updateCategory(id, updateCategoryDto) {
        const category = await this.categoryModel
            .findByIdAndUpdate(id, updateCategoryDto, { new: true })
            .exec();
        if (!category) {
            throw new common_1.NotFoundException('دسته‌بندی یافت نشد');
        }
        return category;
    }
    async deleteCategory(id) {
        const result = await this.categoryModel.deleteOne({ _id: id }).exec();
        if (result.deletedCount === 0) {
            throw new common_1.NotFoundException('دسته‌بندی یافت نشد');
        }
    }
    async createService(createServiceDto) {
        const service = new this.serviceModel(createServiceDto);
        return service.save();
    }
    async getAllServices(categoryId, isFeatured) {
        const filter = { isActive: true };
        if (categoryId)
            filter.categoryId = categoryId;
        if (isFeatured !== undefined)
            filter.isFeatured = isFeatured;
        return this.serviceModel
            .find(filter)
            .populate('categoryId')
            .sort({ order: 1, createdAt: -1 })
            .exec();
    }
    async getServiceById(id) {
        const service = await this.serviceModel
            .findById(id)
            .populate('categoryId')
            .exec();
        if (!service) {
            throw new common_1.NotFoundException('خدمات یافت نشد');
        }
        await this.serviceModel.updateOne({ _id: id }, { $inc: { viewCount: 1 } });
        return service;
    }
    async getServiceBySlug(slug) {
        const service = await this.serviceModel
            .findOne({ slug, isActive: true })
            .populate('categoryId')
            .exec();
        if (!service) {
            throw new common_1.NotFoundException('خدمات یافت نشد');
        }
        await this.serviceModel.updateOne({ slug }, { $inc: { viewCount: 1 } });
        return service;
    }
    async updateService(id, updateServiceDto) {
        const service = await this.serviceModel
            .findByIdAndUpdate(id, updateServiceDto, { new: true })
            .populate('categoryId')
            .exec();
        if (!service) {
            throw new common_1.NotFoundException('خدمات یافت نشد');
        }
        return service;
    }
    async deleteService(id) {
        const result = await this.serviceModel.deleteOne({ _id: id }).exec();
        if (result.deletedCount === 0) {
            throw new common_1.NotFoundException('خدمات یافت نشد');
        }
    }
    async searchServices(query) {
        return this.serviceModel
            .find({
            isActive: true,
            $or: [
                { title: { $regex: query, $options: 'i' } },
                { description: { $regex: query, $options: 'i' } },
            ],
        })
            .populate('categoryId')
            .sort({ order: 1 })
            .exec();
    }
    async createRating(userId, createRatingDto) {
        const service = await this.serviceModel.findById(createRatingDto.serviceId);
        if (!service) {
            throw new common_1.NotFoundException('خدمات یافت نشد');
        }
        const existingRating = await this.ratingModel.findOne({
            serviceId: createRatingDto.serviceId,
            userId,
        });
        if (existingRating) {
            throw new common_1.BadRequestException('شما قبلاً به این خدمت امتیاز داده‌اید');
        }
        const rating = new this.ratingModel({
            ...createRatingDto,
            userId,
        });
        return rating.save();
    }
    async updateRating(userId, ratingId, updateRatingDto) {
        const rating = await this.ratingModel.findOne({ _id: ratingId, userId });
        if (!rating) {
            throw new common_1.NotFoundException('امتیاز یافت نشد یا شما مجاز به ویرایش آن نیستید');
        }
        Object.assign(rating, updateRatingDto);
        return rating.save();
    }
    async deleteRating(userId, ratingId) {
        const result = await this.ratingModel.deleteOne({ _id: ratingId, userId });
        if (result.deletedCount === 0) {
            throw new common_1.NotFoundException('امتیاز یافت نشد یا شما مجاز به حذف آن نیستید');
        }
    }
    async getServiceRatings(serviceId) {
        return this.ratingModel
            .find({ serviceId, isActive: true })
            .populate('userId', 'firstName lastName')
            .sort({ createdAt: -1 })
            .exec();
    }
    async getServiceAverageRating(serviceId) {
        const ratings = await this.ratingModel.find({ serviceId, isActive: true });
        if (ratings.length === 0) {
            return { average: 0, count: 0 };
        }
        const sum = ratings.reduce((acc, rating) => acc + rating.rating, 0);
        const average = sum / ratings.length;
        return {
            average: Math.round(average * 10) / 10,
            count: ratings.length,
        };
    }
    async getUserRating(userId, serviceId) {
        return this.ratingModel.findOne({ userId, serviceId, isActive: true }).exec();
    }
    async getAllRatings(page = 1, limit = 20) {
        const skip = (page - 1) * limit;
        const [ratings, total] = await Promise.all([
            this.ratingModel
                .find({ isActive: true })
                .populate('userId', 'firstName lastName email')
                .populate('serviceId', 'title')
                .sort({ createdAt: -1 })
                .skip(skip)
                .limit(limit)
                .exec(),
            this.ratingModel.countDocuments({ isActive: true }),
        ]);
        return {
            ratings,
            total,
            page,
            totalPages: Math.ceil(total / limit),
        };
    }
    async toggleRatingStatus(ratingId) {
        const rating = await this.ratingModel.findById(ratingId);
        if (!rating) {
            throw new common_1.NotFoundException('امتیاز یافت نشد');
        }
        rating.isActive = !rating.isActive;
        return rating.save();
    }
};
exports.WelfareService = WelfareService;
exports.WelfareService = WelfareService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(category_schema_1.Category.name)),
    __param(1, (0, mongoose_1.InjectModel)(service_schema_1.Service.name)),
    __param(2, (0, mongoose_1.InjectModel)(rating_schema_1.Rating.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model,
        mongoose_2.Model])
], WelfareService);
//# sourceMappingURL=welfare.service.js.map