import { Model } from 'mongoose';
import { Category, CategoryDocument } from './schemas/category.schema';
import { Service, ServiceDocument } from './schemas/service.schema';
import { Rating, RatingDocument } from './schemas/rating.schema';
import { CreateCategoryDto } from './dto/create-category.dto';
import { UpdateCategoryDto } from './dto/update-category.dto';
import { CreateServiceDto } from './dto/create-service.dto';
import { UpdateServiceDto } from './dto/update-service.dto';
import { CreateRatingDto } from './dto/create-rating.dto';
import { UpdateRatingDto } from './dto/update-rating.dto';
export declare class WelfareService {
    private categoryModel;
    private serviceModel;
    private ratingModel;
    constructor(categoryModel: Model<CategoryDocument>, serviceModel: Model<ServiceDocument>, ratingModel: Model<RatingDocument>);
    createCategory(createCategoryDto: CreateCategoryDto): Promise<Category>;
    getAllCategories(includeInactive?: boolean): Promise<any>;
    getCategoryById(id: string): Promise<Category>;
    updateCategory(id: string, updateCategoryDto: UpdateCategoryDto): Promise<Category>;
    deleteCategory(id: string): Promise<void>;
    createService(createServiceDto: CreateServiceDto): Promise<Service>;
    getAllServices(categoryId?: string, isFeatured?: boolean): Promise<Service[]>;
    getServiceById(id: string): Promise<Service>;
    getServiceBySlug(slug: string): Promise<Service>;
    updateService(id: string, updateServiceDto: UpdateServiceDto): Promise<Service>;
    deleteService(id: string): Promise<void>;
    searchServices(query: string): Promise<Service[]>;
    createRating(userId: string, createRatingDto: CreateRatingDto): Promise<Rating>;
    updateRating(userId: string, ratingId: string, updateRatingDto: UpdateRatingDto): Promise<Rating>;
    deleteRating(userId: string, ratingId: string): Promise<void>;
    getServiceRatings(serviceId: string): Promise<Rating[]>;
    getServiceAverageRating(serviceId: string): Promise<{
        average: number;
        count: number;
    }>;
    getUserRating(userId: string, serviceId: string): Promise<Rating | null>;
    getAllRatings(page?: number, limit?: number): Promise<{
        ratings: Rating[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    toggleRatingStatus(ratingId: string): Promise<Rating>;
}
