"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WelfareController = void 0;
const common_1 = require("@nestjs/common");
const welfare_service_1 = require("./welfare.service");
const update_service_dto_1 = require("./dto/update-service.dto");
const create_rating_dto_1 = require("./dto/create-rating.dto");
const update_rating_dto_1 = require("./dto/update-rating.dto");
const jwt_auth_guard_1 = require("../auth/guards/jwt-auth.guard");
const roles_guard_1 = require("../auth/roles/roles.guard");
const roles_decorator_1 = require("../auth/roles/roles.decorator");
const platform_express_1 = require("@nestjs/platform-express");
const multer_1 = require("multer");
const path_1 = require("path");
let WelfareController = class WelfareController {
    constructor(welfareService) {
        this.welfareService = welfareService;
    }
    getAllCategories(includeInactive) {
        return this.welfareService.getAllCategories(includeInactive === 'true');
    }
    getCategoryById(id) {
        return this.welfareService.getCategoryById(id);
    }
    createCategory(createCategoryDto) {
        return this.welfareService.createCategory(createCategoryDto);
    }
    updateCategory(id, updateCategoryDto) {
        return this.welfareService.updateCategory(id, updateCategoryDto);
    }
    deleteCategory(id) {
        return this.welfareService.deleteCategory(id);
    }
    uploadImage(file) {
        return { filename: file.filename };
    }
    getAllServices(categoryId, isFeatured) {
        return this.welfareService.getAllServices(categoryId, isFeatured === 'true' ? true : isFeatured === 'false' ? false : undefined);
    }
    searchServices(query) {
        return this.welfareService.searchServices(query);
    }
    getServiceById(id) {
        return this.welfareService.getServiceById(id);
    }
    getServiceBySlug(slug) {
        return this.welfareService.getServiceBySlug(slug);
    }
    createService(createServiceDto) {
        return this.welfareService.createService(createServiceDto);
    }
    updateService(id, updateServiceDto) {
        return this.welfareService.updateService(id, updateServiceDto);
    }
    deleteService(id) {
        return this.welfareService.deleteService(id);
    }
    createRating(req, createRatingDto) {
        return this.welfareService.createRating(req.user.userId, createRatingDto);
    }
    updateRating(req, id, updateRatingDto) {
        return this.welfareService.updateRating(req.user.userId, id, updateRatingDto);
    }
    deleteRating(req, id) {
        return this.welfareService.deleteRating(req.user.userId, id);
    }
    getServiceRatings(id) {
        return this.welfareService.getServiceRatings(id);
    }
    getServiceAverageRating(id) {
        return this.welfareService.getServiceAverageRating(id);
    }
    getUserRating(req, id) {
        return this.welfareService.getUserRating(req.user.userId, id);
    }
    getAllRatings(page, limit) {
        return this.welfareService.getAllRatings(page ? parseInt(page) : 1, limit ? parseInt(limit) : 20);
    }
    toggleRatingStatus(id) {
        return this.welfareService.toggleRatingStatus(id);
    }
};
exports.WelfareController = WelfareController;
__decorate([
    (0, common_1.Get)('categories'),
    __param(0, (0, common_1.Query)('includeInactive')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getAllCategories", null);
__decorate([
    (0, common_1.Get)('categories/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getCategoryById", null);
__decorate([
    (0, common_1.Post)('categories'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "createCategory", null);
__decorate([
    (0, common_1.Put)('categories/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "updateCategory", null);
__decorate([
    (0, common_1.Delete)('categories/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "deleteCategory", null);
__decorate([
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    (0, common_1.Post)('upload-image'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file', {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads/documents',
            filename: (req, file, cb) => {
                const uniqueSuffix = Date.now() + '-' + Math.round(Math.random() * 1e9);
                cb(null, `category-${uniqueSuffix}${(0, path_1.extname)(file.originalname)}`);
            },
        }),
    })),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "uploadImage", null);
__decorate([
    (0, common_1.Get)('services'),
    __param(0, (0, common_1.Query)('categoryId')),
    __param(1, (0, common_1.Query)('isFeatured')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getAllServices", null);
__decorate([
    (0, common_1.Get)('services/search'),
    __param(0, (0, common_1.Query)('q')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "searchServices", null);
__decorate([
    (0, common_1.Get)('services/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getServiceById", null);
__decorate([
    (0, common_1.Get)('services/slug/:slug'),
    __param(0, (0, common_1.Param)('slug')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getServiceBySlug", null);
__decorate([
    (0, common_1.Post)('services'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "createService", null);
__decorate([
    (0, common_1.Put)('services/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_service_dto_1.UpdateServiceDto]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "updateService", null);
__decorate([
    (0, common_1.Delete)('services/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "deleteService", null);
__decorate([
    (0, common_1.Post)('ratings'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, create_rating_dto_1.CreateRatingDto]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "createRating", null);
__decorate([
    (0, common_1.Put)('ratings/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __param(2, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, update_rating_dto_1.UpdateRatingDto]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "updateRating", null);
__decorate([
    (0, common_1.Delete)('ratings/:id'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "deleteRating", null);
__decorate([
    (0, common_1.Get)('services/:id/ratings'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getServiceRatings", null);
__decorate([
    (0, common_1.Get)('services/:id/ratings/average'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getServiceAverageRating", null);
__decorate([
    (0, common_1.Get)('services/:id/ratings/user'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard),
    __param(0, (0, common_1.Req)()),
    __param(1, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getUserRating", null);
__decorate([
    (0, common_1.Get)('ratings'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Query)('page')),
    __param(1, (0, common_1.Query)('limit')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "getAllRatings", null);
__decorate([
    (0, common_1.Put)('ratings/:id/toggle-status'),
    (0, common_1.UseGuards)(jwt_auth_guard_1.JwtAuthGuard, roles_guard_1.RolesGuard),
    (0, roles_decorator_1.Roles)('admin', 'operator'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], WelfareController.prototype, "toggleRatingStatus", null);
exports.WelfareController = WelfareController = __decorate([
    (0, common_1.Controller)('welfare'),
    __metadata("design:paramtypes", [welfare_service_1.WelfareService])
], WelfareController);
//# sourceMappingURL=welfare.controller.js.map