import { WelfareService } from './welfare.service';
import { UpdateServiceDto } from './dto/update-service.dto';
import { CreateRatingDto } from './dto/create-rating.dto';
import { UpdateRatingDto } from './dto/update-rating.dto';
export declare class WelfareController {
    private readonly welfareService;
    constructor(welfareService: WelfareService);
    getAllCategories(includeInactive?: string): Promise<any>;
    getCategoryById(id: string): Promise<import("./schemas/category.schema").Category>;
    createCategory(createCategoryDto: any): Promise<import("./schemas/category.schema").Category>;
    updateCategory(id: string, updateCategoryDto: any): Promise<import("./schemas/category.schema").Category>;
    deleteCategory(id: string): Promise<void>;
    uploadImage(file: any): {
        filename: any;
    };
    getAllServices(categoryId?: string, isFeatured?: string): Promise<import("./schemas/service.schema").Service[]>;
    searchServices(query: string): Promise<import("./schemas/service.schema").Service[]>;
    getServiceById(id: string): Promise<import("./schemas/service.schema").Service>;
    getServiceBySlug(slug: string): Promise<import("./schemas/service.schema").Service>;
    createService(createServiceDto: any): Promise<import("./schemas/service.schema").Service>;
    updateService(id: string, updateServiceDto: UpdateServiceDto): Promise<import("./schemas/service.schema").Service>;
    deleteService(id: string): Promise<void>;
    createRating(req: any, createRatingDto: CreateRatingDto): Promise<import("./schemas/rating.schema").Rating>;
    updateRating(req: any, id: string, updateRatingDto: UpdateRatingDto): Promise<import("./schemas/rating.schema").Rating>;
    deleteRating(req: any, id: string): Promise<void>;
    getServiceRatings(id: string): Promise<import("./schemas/rating.schema").Rating[]>;
    getServiceAverageRating(id: string): Promise<{
        average: number;
        count: number;
    }>;
    getUserRating(req: any, id: string): Promise<import("./schemas/rating.schema").Rating>;
    getAllRatings(page?: string, limit?: string): Promise<{
        ratings: import("./schemas/rating.schema").Rating[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    toggleRatingStatus(id: string): Promise<import("./schemas/rating.schema").Rating>;
}
