"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const user_schema_1 = require("./schemas/user.schema");
const XLSX = require("xlsx");
let UsersService = class UsersService {
    constructor(userModel) {
        this.userModel = userModel;
    }
    async getUserById(userId) {
        const user = await this.userModel.findById(userId);
        if (!user)
            throw new common_1.UnauthorizedException('User not found');
        return user;
    }
    async create(dto) {
        if (dto.nationalityCode && dto.nationalityCode.trim()) {
            const existingUser = await this.userModel.findOne({
                nationalityCode: dto.nationalityCode
            });
            if (existingUser) {
                throw new Error('National Code already exists');
            }
        }
        const created = new this.userModel(dto);
        return created.save();
    }
    async findByPhone(phone) {
        return this.userModel.findOne({ phone });
    }
    async findAll() {
        return this.userModel.find().exec();
    }
    async getUsersList(query) {
        const page = Math.max(query.page || 1, 1);
        const limit = Math.min(Math.max(query.limit || 20, 1), 100);
        const skip = (page - 1) * limit;
        const sortField = query.sortBy || 'createdAt';
        const sortOrder = query.sortOrder === 'asc' ? 1 : -1;
        const filter = {
            isDeleted: { $ne: true }
        };
        if (query.userRole) {
            filter.userRole = query.userRole;
        }
        if (query.searchQuery && query.searchQuery.trim()) {
            const searchRegex = new RegExp(query.searchQuery.trim(), 'i');
            filter.$or = [
                { firstName: searchRegex },
                { lastName: searchRegex },
                { phone: searchRegex },
                { email: searchRegex },
                { nationalityCode: searchRegex },
            ];
        }
        const [users, total] = await Promise.all([
            this.userModel
                .find(filter)
                .select('firstName lastName firstName_locale lastName_locale phone email nationalityCode userRole createdAt updatedAt profileImage isDeleted')
                .sort({ [sortField]: sortOrder })
                .skip(skip)
                .limit(limit)
                .lean(),
            this.userModel.countDocuments(filter),
        ]);
        return {
            data: users,
            pagination: {
                total,
                page,
                limit,
                totalPages: Math.ceil(total / limit),
            },
        };
    }
    async findById(id) {
        return this.userModel.findById(id).exec();
    }
    async update(id, updateData) {
        return this.userModel.findByIdAndUpdate(id, updateData, { new: true }).exec();
    }
    async delete(id) {
        return this.userModel.findByIdAndUpdate(id, { isDeleted: true }, { new: true }).exec();
    }
    async importUsersFromExcel(buffer) {
        const workbook = XLSX.read(buffer, { type: 'buffer' });
        const sheetName = workbook.SheetNames[0];
        const sheet = workbook.Sheets[sheetName];
        const data = XLSX.utils.sheet_to_json(sheet);
        const results = {
            success: 0,
            failed: 0,
            errors: [],
        };
        for (let i = 0; i < data.length; i++) {
            const row = data[i];
            const rowNumber = i + 2;
            try {
                const userData = {
                    phone: row['phone'] || row['شماره تماس'] || row['تلفن'],
                    firstName: row['firstName'] || row['نام'],
                    lastName: row['lastName'] || row['نام خانوادگی'],
                    nationalityCode: row['nationalityCode'] || row['کد ملی'],
                    medicalSystemNumber: row['medicalSystemNumber'] || row['شماره نظام پزشکی'] || '',
                    sex: row['sex'] || row['جنسیت'] || '0',
                    userRole: row['userRole'] || row['نقش'] || 'user',
                };
                if (!userData.phone) {
                    results.failed++;
                    results.errors.push({
                        row: rowNumber,
                        error: 'شماره تماس الزامی است',
                    });
                    continue;
                }
                userData.phone = String(userData.phone).trim();
                const existingUser = await this.userModel.findOne({ phone: userData.phone });
                if (existingUser) {
                    results.failed++;
                    results.errors.push({
                        row: rowNumber,
                        phone: userData.phone,
                        error: 'کاربر با این شماره تماس قبلاً ثبت شده است',
                    });
                    continue;
                }
                if (userData.nationalityCode && userData.nationalityCode.trim()) {
                    const existingNationalCode = await this.userModel.findOne({
                        nationalityCode: userData.nationalityCode,
                    });
                    if (existingNationalCode) {
                        results.failed++;
                        results.errors.push({
                            row: rowNumber,
                            phone: userData.phone,
                            error: 'کد ملی تکراری است',
                        });
                        continue;
                    }
                }
                const newUser = new this.userModel(userData);
                await newUser.save();
                results.success++;
            }
            catch (error) {
                results.failed++;
                results.errors.push({
                    row: rowNumber,
                    phone: row['phone'] || row['شماره تماس'],
                    error: error.message || 'خطای ناشناخته',
                });
            }
        }
        return results;
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(user_schema_1.User.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], UsersService);
//# sourceMappingURL=users.service.js.map