"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpecialitiesService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const speciality_schema_1 = require("./schemas/speciality.schema");
let SpecialitiesService = class SpecialitiesService {
    constructor(specialityModel, userModel) {
        this.specialityModel = specialityModel;
        this.userModel = userModel;
    }
    async findAll() {
        return this.specialityModel.find({ isDeleted: { $ne: true } }).exec();
    }
    async findById(id) {
        return this.specialityModel.findById(id).exec();
    }
    async getTopSpecialtiesWithDoctors() {
        try {
            const topSpecialityIds = await this.userModel.aggregate([
                {
                    $match: {
                        isDeleted: { $ne: true },
                        userRole: 'dr',
                        specialities: { $exists: true, $ne: [] }
                    }
                },
                {
                    $unwind: '$specialities'
                },
                {
                    $group: {
                        _id: '$specialities',
                        doctorCount: { $sum: 1 }
                    }
                },
                {
                    $sort: { doctorCount: -1 }
                },
                {
                    $limit: 4
                }
            ]).exec();
            const specialityIds = topSpecialityIds.map(item => item._id);
            const specialities = await this.specialityModel.find({
                _id: { $in: specialityIds },
                isDeleted: { $ne: true }
            }).exec();
            const result = specialities.map(spec => {
                const doctorCount = topSpecialityIds.find(item => item._id.toString() === spec._id.toString());
                return {
                    _id: spec._id,
                    title: spec.title,
                    level: spec.level,
                    doctorCount: doctorCount?.doctorCount || 0
                };
            });
            return result;
        }
        catch (error) {
            console.error('Error fetching top specialities:', error);
            return [];
        }
    }
};
exports.SpecialitiesService = SpecialitiesService;
exports.SpecialitiesService = SpecialitiesService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(speciality_schema_1.Speciality.name)),
    __param(1, (0, mongoose_1.InjectModel)('User')),
    __metadata("design:paramtypes", [mongoose_2.Model,
        mongoose_2.Model])
], SpecialitiesService);
//# sourceMappingURL=specialities.service.js.map