import { Document, Schema as MongooseSchema } from 'mongoose';
import { Speciality } from '../../specialities/schemas/speciality.schema';
export declare class Speaker {
    name: string;
    title: string;
    subject: string;
    image: string;
}
export declare class Retraining extends Document {
    title: string;
    organizer: string;
    date: string;
    targetGroups: Speciality[];
    registrationLink: string;
    score: number;
    speakers: Speaker[];
    time: string;
    location: string;
    poster: string;
    secretary: string;
}
export declare const RetrainingSchema: MongooseSchema<Retraining, import("mongoose").Model<Retraining, any, any, any, Document<unknown, any, Retraining, any, {}> & Retraining & Required<{
    _id: import("mongoose").Types.ObjectId;
}> & {
    __v: number;
}, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, Retraining, Document<unknown, {}, import("mongoose").FlatRecord<Retraining>, {}, import("mongoose").ResolveSchemaOptions<import("mongoose").DefaultSchemaOptions>> & import("mongoose").FlatRecord<Retraining> & Required<{
    _id: import("mongoose").Types.ObjectId;
}> & {
    __v: number;
}>;
