"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetrainingService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const retraining_schema_1 = require("./schemas/retraining.schema");
let RetrainingService = class RetrainingService {
    constructor(retrainingModel) {
        this.retrainingModel = retrainingModel;
    }
    async findAll() {
        return this.retrainingModel.find().populate('targetGroups').exec();
    }
    async findOne(id) {
        const item = await this.retrainingModel.findById(id).populate('targetGroups').exec();
        if (!item) {
            throw new common_1.NotFoundException('دوره بازآموزی یافت نشد');
        }
        return item;
    }
    async create(data) {
        const newItem = new this.retrainingModel(data);
        return newItem.save();
    }
    async update(id, data) {
        const updated = await this.retrainingModel
            .findByIdAndUpdate(id, data, { new: true })
            .exec();
        if (!updated) {
            throw new common_1.NotFoundException('دوره بازآموزی یافت نشد');
        }
        return updated;
    }
    async delete(id) {
        return this.retrainingModel.findByIdAndDelete(id).exec();
    }
};
exports.RetrainingService = RetrainingService;
exports.RetrainingService = RetrainingService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(retraining_schema_1.Retraining.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], RetrainingService);
//# sourceMappingURL=retraining.service.js.map