import { Model } from 'mongoose';
import { PushSubscription } from './schemas/push-subscription.schema';
import { Notification } from './schemas/notification.schema';
import { DeliveryLog } from './schemas/delivery-log.schema';
import { SubscribeDto } from './dto/subscribe.dto';
import { CreateNotificationDto } from './dto/create-notification.dto';
import { UpdateNotificationDto } from './dto/update-notification.dto';
export declare class NotificationsService {
    private pushSubscriptionModel;
    private notificationModel;
    private deliveryLogModel;
    private readonly logger;
    constructor(pushSubscriptionModel: Model<PushSubscription>, notificationModel: Model<Notification>, deliveryLogModel: Model<DeliveryLog>);
    subscribe(userId: string, subscribeDto: SubscribeDto): Promise<import("mongoose").Document<unknown, {}, PushSubscription, {}, {}> & PushSubscription & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    unsubscribe(userId: string, endpoint: string): Promise<boolean>;
    getUserSubscriptions(userId: string): Promise<(import("mongoose").Document<unknown, {}, PushSubscription, {}, {}> & PushSubscription & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
    getSubscriptionCount(): Promise<number>;
    createNotification(createDto: CreateNotificationDto): Promise<import("mongoose").Document<unknown, {}, Notification, {}, {}> & Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    updateNotification(id: string, updateDto: UpdateNotificationDto): Promise<import("mongoose").Document<unknown, {}, Notification, {}, {}> & Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    deleteNotification(id: string): Promise<import("mongoose").Document<unknown, {}, Notification, {}, {}> & Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    getAllNotifications(page?: number, limit?: number): Promise<{
        notifications: (import("mongoose").Document<unknown, {}, Notification, {}, {}> & Notification & Required<{
            _id: import("mongoose").Types.ObjectId;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        totalPages: number;
    }>;
    getNotification(id: string): Promise<import("mongoose").Document<unknown, {}, Notification, {}, {}> & Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    sendPushToAll(notification: Notification): Promise<{
        sentCount: number;
        failedCount: number;
    }>;
    private logDelivery;
    getDeliveryLogs(notificationId: string): Promise<(import("mongoose").Document<unknown, {}, DeliveryLog, {}, {}> & DeliveryLog & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
    getVapidPublicKey(): string;
}
