import { NotificationsService } from './notifications.service';
import { SubscribeDto } from './dto/subscribe.dto';
import { CreateNotificationDto } from './dto/create-notification.dto';
import { UpdateNotificationDto } from './dto/update-notification.dto';
export declare class NotificationsController {
    private readonly notificationsService;
    constructor(notificationsService: NotificationsService);
    getVapidPublicKey(): {
        publicKey: string;
    };
    subscribe(req: any, subscribeDto: SubscribeDto): Promise<import("mongoose").Document<unknown, {}, import("./schemas/push-subscription.schema").PushSubscription, {}, {}> & import("./schemas/push-subscription.schema").PushSubscription & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    unsubscribe(req: any, endpoint: string): Promise<{
        success: boolean;
    }>;
    getUserSubscriptions(req: any): Promise<(import("mongoose").Document<unknown, {}, import("./schemas/push-subscription.schema").PushSubscription, {}, {}> & import("./schemas/push-subscription.schema").PushSubscription & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
}
export declare class AdminNotificationsController {
    private readonly notificationsService;
    constructor(notificationsService: NotificationsService);
    getAllNotifications(page?: string, limit?: string): Promise<(import("mongoose").Document<unknown, {}, import("./schemas/notification.schema").Notification, {}, {}> & import("./schemas/notification.schema").Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
    getNotification(id: string): Promise<import("mongoose").Document<unknown, {}, import("./schemas/notification.schema").Notification, {}, {}> & import("./schemas/notification.schema").Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    createNotification(createDto: CreateNotificationDto): Promise<import("mongoose").Document<unknown, {}, import("./schemas/notification.schema").Notification, {}, {}> & import("./schemas/notification.schema").Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    updateNotification(id: string, updateDto: UpdateNotificationDto): Promise<import("mongoose").Document<unknown, {}, import("./schemas/notification.schema").Notification, {}, {}> & import("./schemas/notification.schema").Notification & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    deleteNotification(id: string): Promise<{
        success: boolean;
    }>;
    getSubscriptionCount(): Promise<{
        count: number;
    }>;
    getDeliveryLogs(id: string): Promise<(import("mongoose").Document<unknown, {}, import("./schemas/delivery-log.schema").DeliveryLog, {}, {}> & import("./schemas/delivery-log.schema").DeliveryLog & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
    resendNotification(id: string): Promise<{
        sentCount: number;
        failedCount: number;
    }>;
}
