"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const news_schema_1 = require("./schemas/news.schema");
let NewsService = class NewsService {
    constructor(newsModel) {
        this.newsModel = newsModel;
    }
    async create(createNewsDto) {
        const news = new this.newsModel(createNewsDto);
        return news.save();
    }
    async findAll(type, includeInactive = false) {
        const filter = includeInactive ? {} : { isActive: true };
        if (type)
            filter.type = type;
        return this.newsModel
            .find(filter)
            .sort({ isPinned: -1, publishDate: -1, createdAt: -1 })
            .exec();
    }
    async findById(id) {
        const news = await this.newsModel.findById(id).exec();
        if (!news) {
            throw new common_1.NotFoundException('خبر یافت نشد');
        }
        await this.newsModel.updateOne({ _id: id }, { $inc: { viewCount: 1 } });
        return news;
    }
    async findBySlug(slug) {
        const news = await this.newsModel.findOne({ slug, isActive: true }).exec();
        if (!news) {
            throw new common_1.NotFoundException('خبر یافت نشد');
        }
        await this.newsModel.updateOne({ slug }, { $inc: { viewCount: 1 } });
        return news;
    }
    async update(id, updateNewsDto) {
        const news = await this.newsModel
            .findByIdAndUpdate(id, updateNewsDto, { new: true })
            .exec();
        if (!news) {
            throw new common_1.NotFoundException('خبر یافت نشد');
        }
        return news;
    }
    async remove(id) {
        const result = await this.newsModel.deleteOne({ _id: id }).exec();
        if (result.deletedCount === 0) {
            throw new common_1.NotFoundException('خبر یافت نشد');
        }
    }
    async search(query) {
        return this.newsModel
            .find({
            isActive: true,
            $or: [
                { title: { $regex: query, $options: 'i' } },
                { content: { $regex: query, $options: 'i' } },
                { summary: { $regex: query, $options: 'i' } },
            ],
        })
            .sort({ isPinned: -1, publishDate: -1 })
            .exec();
    }
    async getRecent(limit = 5) {
        return this.newsModel
            .find({ isActive: true })
            .sort({ publishDate: -1, createdAt: -1 })
            .limit(limit)
            .exec();
    }
    async getPinned() {
        return this.newsModel
            .find({ isActive: true, isPinned: true })
            .sort({ order: 1, publishDate: -1 })
            .exec();
    }
};
exports.NewsService = NewsService;
exports.NewsService = NewsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(news_schema_1.News.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], NewsService);
//# sourceMappingURL=news.service.js.map