import { Model } from 'mongoose';
import { News, NewsDocument } from './schemas/news.schema';
import { CreateNewsDto } from './dto/create-news.dto';
import { UpdateNewsDto } from './dto/update-news.dto';
export declare class NewsService {
    private newsModel;
    constructor(newsModel: Model<NewsDocument>);
    create(createNewsDto: CreateNewsDto): Promise<News>;
    findAll(type?: string, includeInactive?: boolean): Promise<News[]>;
    findById(id: string): Promise<News>;
    findBySlug(slug: string): Promise<News>;
    update(id: string, updateNewsDto: UpdateNewsDto): Promise<News>;
    remove(id: string): Promise<void>;
    search(query: string): Promise<News[]>;
    getRecent(limit?: number): Promise<News[]>;
    getPinned(): Promise<News[]>;
}
