import { NewsService } from './news.service';
import { CreateNewsDto } from './dto/create-news.dto';
import { UpdateNewsDto } from './dto/update-news.dto';
export declare class NewsController {
    private readonly newsService;
    constructor(newsService: NewsService);
    findAll(type?: string, includeInactive?: string): Promise<import("./schemas/news.schema").News[]>;
    getRecent(limit?: string): Promise<import("./schemas/news.schema").News[]>;
    getPinned(): Promise<import("./schemas/news.schema").News[]>;
    search(query: string): Promise<import("./schemas/news.schema").News[]>;
    findById(id: string): Promise<import("./schemas/news.schema").News>;
    findBySlug(slug: string): Promise<import("./schemas/news.schema").News>;
    create(createNewsDto: CreateNewsDto): Promise<import("./schemas/news.schema").News>;
    update(id: string, updateNewsDto: UpdateNewsDto): Promise<import("./schemas/news.schema").News>;
    remove(id: string): Promise<void>;
}
