import { Document } from 'mongoose';
export declare enum EventStatus {
    UPCOMING = "upcoming",
    ONGOING = "ongoing",
    COMPLETED = "completed",
    CANCELLED = "cancelled"
}
export declare class Event extends Document {
    title: string;
    description: string;
    summary: string;
    eventDate: Date;
    endDate: Date;
    location: string;
    address: string;
    posterImage: string;
    gallery: string[];
    videos: string[];
    status: EventStatus;
    organizerName: string;
    organizerContact: string;
    capacity: number;
    registeredCount: number;
    registrationRequired: boolean;
    registrationDeadline: Date;
    tags: string[];
    isPublished: boolean;
    viewCount: number;
    slug: string;
    createdBy: string;
}
export declare const EventSchema: import("mongoose").Schema<Event, import("mongoose").Model<Event, any, any, any, Document<unknown, any, Event, any, {}> & Event & Required<{
    _id: import("mongoose").Types.ObjectId;
}> & {
    __v: number;
}, any>, {}, {}, {}, {}, import("mongoose").DefaultSchemaOptions, Event, Document<unknown, {}, import("mongoose").FlatRecord<Event>, {}, import("mongoose").ResolveSchemaOptions<import("mongoose").DefaultSchemaOptions>> & import("mongoose").FlatRecord<Event> & Required<{
    _id: import("mongoose").Types.ObjectId;
}> & {
    __v: number;
}>;
