"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const event_schema_1 = require("./schemas/event.schema");
let EventsService = class EventsService {
    constructor(eventModel) {
        this.eventModel = eventModel;
    }
    generateSlug(title) {
        return title
            .toLowerCase()
            .replace(/[^\w\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .trim() + '-' + Date.now();
    }
    async create(createEventDto, userId) {
        const slug = this.generateSlug(createEventDto.title);
        const event = new this.eventModel({
            ...createEventDto,
            slug,
            createdBy: userId,
        });
        return await event.save();
    }
    async findAll(page = 1, limit = 20, status) {
        const skip = (page - 1) * limit;
        const query = { isPublished: true };
        if (status) {
            query.status = status;
        }
        const [events, total] = await Promise.all([
            this.eventModel
                .find(query)
                .sort({ eventDate: -1 })
                .skip(skip)
                .limit(limit)
                .exec(),
            this.eventModel.countDocuments(query),
        ]);
        return { events, total };
    }
    async findUpcoming(limit = 10) {
        const now = new Date();
        return await this.eventModel
            .find({
            isPublished: true,
            status: event_schema_1.EventStatus.UPCOMING,
            eventDate: { $gte: now },
        })
            .sort({ eventDate: 1 })
            .limit(limit)
            .exec();
    }
    async findCompleted(page = 1, limit = 20) {
        const skip = (page - 1) * limit;
        const query = {
            isPublished: true,
            status: event_schema_1.EventStatus.COMPLETED,
        };
        const [events, total] = await Promise.all([
            this.eventModel
                .find(query)
                .sort({ eventDate: -1 })
                .skip(skip)
                .limit(limit)
                .exec(),
            this.eventModel.countDocuments(query),
        ]);
        return { events, total };
    }
    async findOne(id) {
        const event = await this.eventModel.findById(id).exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        event.viewCount += 1;
        await event.save();
        return event;
    }
    async findBySlug(slug) {
        const event = await this.eventModel.findOne({ slug, isPublished: true }).exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        event.viewCount += 1;
        await event.save();
        return event;
    }
    async update(id, updateEventDto) {
        const event = await this.eventModel
            .findByIdAndUpdate(id, updateEventDto, { new: true })
            .exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        return event;
    }
    async addToGallery(id, images) {
        const event = await this.eventModel.findById(id).exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        event.gallery.push(...images);
        return await event.save();
    }
    async addVideos(id, videos) {
        const event = await this.eventModel.findById(id).exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        event.videos.push(...videos);
        return await event.save();
    }
    async updateStatus(id, status) {
        const event = await this.eventModel
            .findByIdAndUpdate(id, { status }, { new: true })
            .exec();
        if (!event) {
            throw new common_1.NotFoundException('Event not found');
        }
        return event;
    }
    async delete(id) {
        const result = await this.eventModel.findByIdAndDelete(id).exec();
        if (!result) {
            throw new common_1.NotFoundException('Event not found');
        }
    }
    async search(query, page = 1, limit = 20) {
        const skip = (page - 1) * limit;
        const searchQuery = {
            isPublished: true,
            $or: [
                { title: { $regex: query, $options: 'i' } },
                { description: { $regex: query, $options: 'i' } },
                { tags: { $in: [new RegExp(query, 'i')] } },
            ],
        };
        const [events, total] = await Promise.all([
            this.eventModel
                .find(searchQuery)
                .sort({ eventDate: -1 })
                .skip(skip)
                .limit(limit)
                .exec(),
            this.eventModel.countDocuments(searchQuery),
        ]);
        return { events, total };
    }
};
exports.EventsService = EventsService;
exports.EventsService = EventsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(event_schema_1.Event.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], EventsService);
//# sourceMappingURL=events.service.js.map