import { Model } from 'mongoose';
import { Event, EventStatus } from './schemas/event.schema';
import { CreateEventDto } from './dto/create-event.dto';
import { UpdateEventDto } from './dto/update-event.dto';
export declare class EventsService {
    private eventModel;
    constructor(eventModel: Model<Event>);
    private generateSlug;
    create(createEventDto: CreateEventDto, userId: string): Promise<Event>;
    findAll(page?: number, limit?: number, status?: EventStatus): Promise<{
        events: Event[];
        total: number;
    }>;
    findUpcoming(limit?: number): Promise<Event[]>;
    findCompleted(page?: number, limit?: number): Promise<{
        events: Event[];
        total: number;
    }>;
    findOne(id: string): Promise<Event>;
    findBySlug(slug: string): Promise<Event>;
    update(id: string, updateEventDto: UpdateEventDto): Promise<Event>;
    addToGallery(id: string, images: string[]): Promise<Event>;
    addVideos(id: string, videos: string[]): Promise<Event>;
    updateStatus(id: string, status: EventStatus): Promise<Event>;
    delete(id: string): Promise<void>;
    search(query: string, page?: number, limit?: number): Promise<{
        events: Event[];
        total: number;
    }>;
}
