import { EventsService } from './events.service';
import { CreateEventDto } from './dto/create-event.dto';
import { UpdateEventDto } from './dto/update-event.dto';
import { EventStatus } from './schemas/event.schema';
export declare class EventsController {
    private readonly eventsService;
    constructor(eventsService: EventsService);
    findAll(page?: string, limit?: string, status?: EventStatus): Promise<{
        events: import("./schemas/event.schema").Event[];
        total: number;
    }>;
    findUpcoming(limit?: string): Promise<import("./schemas/event.schema").Event[]>;
    findCompleted(page?: string, limit?: string): Promise<{
        events: import("./schemas/event.schema").Event[];
        total: number;
    }>;
    search(query: string, page?: string, limit?: string): Promise<{
        events: import("./schemas/event.schema").Event[];
        total: number;
    }>;
    findOne(id: string): Promise<import("./schemas/event.schema").Event>;
    findBySlug(slug: string): Promise<import("./schemas/event.schema").Event>;
    create(createEventDto: CreateEventDto, req: any): Promise<import("./schemas/event.schema").Event>;
    update(id: string, updateEventDto: UpdateEventDto): Promise<import("./schemas/event.schema").Event>;
    addToGallery(id: string, images: string[]): Promise<import("./schemas/event.schema").Event>;
    addVideos(id: string, videos: string[]): Promise<import("./schemas/event.schema").Event>;
    updateStatus(id: string, status: EventStatus): Promise<import("./schemas/event.schema").Event>;
    delete(id: string): Promise<{
        success: boolean;
    }>;
}
