"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const mongoose_2 = require("mongoose");
const content_schema_1 = require("./schemas/content.schema");
let ContentService = class ContentService {
    constructor(contentModel) {
        this.contentModel = contentModel;
    }
    async create(createContentDto) {
        try {
            return await this.contentModel.create(createContentDto);
        }
        catch (error) {
            if (error.code === 11000) {
                throw new common_1.BadRequestException('محتوای مورد نظر قبلا ثبت شده است.');
            }
            throw new common_1.BadRequestException('Unable to create content entry.');
        }
    }
    findAll(filters = {}) {
        const query = {};
        if (filters.value) {
            query.value = filters.value;
        }
        if (filters.locale) {
            query.locale = filters.locale;
        }
        return this.contentModel.find(query).sort({ value: 1, locale: 1 }).lean().exec();
    }
    async findOne(id) {
        const entry = await this.contentModel.findById(id).lean();
        if (!entry) {
            throw new common_1.NotFoundException('محتوا یافت نشد.');
        }
        return entry;
    }
    async findByValueAndLocale(value, locale) {
        if (!value) {
            throw new common_1.BadRequestException('کلید محتوا الزامی است.');
        }
        const baseQuery = { value };
        if (locale) {
            baseQuery.locale = locale;
        }
        let entry = await this.contentModel.findOne(baseQuery).lean();
        if (!entry && locale) {
            entry = await this.contentModel.findOne({ value, locale: 'fa' }).lean();
        }
        if (!entry) {
            throw new common_1.NotFoundException('محتوا برای کلید داده‌شده پیدا نشده است.');
        }
        return entry;
    }
    async update(id, updateContentDto) {
        const updated = await this.contentModel
            .findByIdAndUpdate(id, updateContentDto, { new: true, runValidators: true })
            .lean();
        if (!updated) {
            throw new common_1.NotFoundException('محتوا یافت نشد.');
        }
        return updated;
    }
    async remove(id) {
        const deleted = await this.contentModel.findByIdAndDelete(id).lean();
        if (!deleted) {
            throw new common_1.NotFoundException('محتوا یافت نشد.');
        }
        return deleted;
    }
};
exports.ContentService = ContentService;
exports.ContentService = ContentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(content_schema_1.Content.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], ContentService);
//# sourceMappingURL=content.service.js.map