import { Model } from 'mongoose';
import { CreateContentDto } from './dto/create-content.dto';
import { UpdateContentDto } from './dto/update-content.dto';
import { Content, ContentDocument } from './schemas/content.schema';
export declare class ContentService {
    private readonly contentModel;
    constructor(contentModel: Model<ContentDocument>);
    create(createContentDto: CreateContentDto): Promise<import("mongoose").Document<unknown, {}, ContentDocument, {}, {}> & Content & import("mongoose").Document<import("mongoose").Types.ObjectId, any, any, Record<string, any>, {}> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    findAll(filters?: {
        value?: string;
        locale?: string;
    }): Promise<(import("mongoose").FlattenMaps<ContentDocument> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    })[]>;
    findOne(id: string): Promise<import("mongoose").FlattenMaps<ContentDocument> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    findByValueAndLocale(value: string, locale?: string): Promise<import("mongoose").FlattenMaps<ContentDocument> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    update(id: string, updateContentDto: UpdateContentDto): Promise<import("mongoose").FlattenMaps<ContentDocument> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    remove(id: string): Promise<import("mongoose").FlattenMaps<ContentDocument> & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
}
