import { Model } from 'mongoose';
import { ContactMessage } from './schemas/contact-message.schema';
import { SmsService } from '../../shared/sms.service';
export declare class ContactService {
    private contactModel;
    private smsService;
    private rateLimitStore;
    private numericCaptchaStore;
    private readonly numericCaptchaTTL;
    constructor(contactModel: Model<ContactMessage>, smsService: SmsService);
    submitMessage(dto: any, clientIp?: string): Promise<import("mongoose").Document<unknown, {}, ContactMessage, {}, {}> & ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    private verifyNumericCaptcha;
    generateNumericCaptcha(length?: number): {
        token: `${string}-${string}-${string}-${string}-${string}`;
        challenge: string;
        expiresAt: number;
    };
    private purgeExpiredNumericCaptchas;
    private checkRateLimit;
    private notifyAdminsViaSms;
    getMessages(page?: number, limit?: number): Promise<{
        data: (import("mongoose").FlattenMaps<ContactMessage> & Required<{
            _id: import("mongoose").Types.ObjectId;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        hasMore: boolean;
    }>;
    markAsRead(messageId: string): Promise<import("mongoose").Document<unknown, {}, ContactMessage, {}, {}> & ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    deleteMessage(messageId: string): Promise<import("mongoose").Document<unknown, {}, ContactMessage, {}, {}> & ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
}
