import { ContactService } from './contact.service';
import { Request } from 'express';
export declare class ContactController {
    private readonly contactService;
    constructor(contactService: ContactService);
    submitMessage(dto: any, request: Request): Promise<import("mongoose").Document<unknown, {}, import("./schemas/contact-message.schema").ContactMessage, {}, {}> & import("./schemas/contact-message.schema").ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    getNumericCaptcha(): Promise<{
        token: `${string}-${string}-${string}-${string}-${string}`;
        challenge: string;
        expiresAt: number;
    }>;
    getMessages(page?: string, limit?: string): Promise<{
        data: (import("mongoose").FlattenMaps<import("./schemas/contact-message.schema").ContactMessage> & Required<{
            _id: import("mongoose").Types.ObjectId;
        }> & {
            __v: number;
        })[];
        total: number;
        page: number;
        limit: number;
        hasMore: boolean;
    }>;
    markAsRead(messageId: string): Promise<import("mongoose").Document<unknown, {}, import("./schemas/contact-message.schema").ContactMessage, {}, {}> & import("./schemas/contact-message.schema").ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
    deleteMessage(messageId: string): Promise<import("mongoose").Document<unknown, {}, import("./schemas/contact-message.schema").ContactMessage, {}, {}> & import("./schemas/contact-message.schema").ContactMessage & Required<{
        _id: import("mongoose").Types.ObjectId;
    }> & {
        __v: number;
    }>;
}
