import { UsersService } from '../users/users.service';
import { JwtService } from '@nestjs/jwt';
import { ConfigService } from '@nestjs/config';
import { SmsService } from '../../shared/sms.service';
export declare class AuthService {
    private usersService;
    private jwtService;
    private config;
    private smsService;
    private readonly MAX_LOGIN_ATTEMPTS;
    private readonly LOCK_DURATION_MS;
    constructor(usersService: UsersService, jwtService: JwtService, config: ConfigService, smsService: SmsService);
    private ensureAccountNotLocked;
    private recordFailedLoginAttempt;
    private resetLoginAttempts;
    requestOtp(phone: string): Promise<{
        success: boolean;
        resent: boolean;
    } | {
        success: boolean;
        resent?: undefined;
    }>;
    verifyOtp(phone: string, code: string): Promise<{
        accessToken: string;
        refreshToken: string;
        user: {
            id: import("mongoose").Types.ObjectId;
            phone: string;
            firstName: string;
            lastName: string;
            profileImage: string;
            userRole: "admin" | "user";
        };
    }>;
    refreshToken(token: string): Promise<{
        accessToken: string;
        refreshToken: string;
    }>;
    getUserById(userId: string): Promise<{
        id: import("mongoose").Types.ObjectId;
        phone: string;
        firstName: string;
        lastName: string;
        profileImage: string;
        userRole: "admin" | "user";
    }>;
}
