import { AuthService } from './auth.service';
import { RequestOtpDto } from './dto/request-otp.dto';
import { VerifyOtpDto } from './dto/verify-otp.dto';
export declare class AuthController {
    private authService;
    constructor(authService: AuthService);
    requestOtp(dto: RequestOtpDto): Promise<{
        success: boolean;
        resent: boolean;
    } | {
        success: boolean;
        resent?: undefined;
    }>;
    verifyOtp(dto: VerifyOtpDto): Promise<{
        accessToken: string;
        refreshToken: string;
        user: {
            id: import("mongoose").Types.ObjectId;
            phone: string;
            firstName: string;
            lastName: string;
            profileImage: string;
            userRole: "admin" | "user";
        };
    }>;
    refresh(refreshToken: string): Promise<{
        accessToken: string;
        refreshToken: string;
    }>;
    getMe(req: any): Promise<{
        id: import("mongoose").Types.ObjectId;
        phone: string;
        firstName: string;
        lastName: string;
        profileImage: string;
        userRole: "admin" | "user";
    }>;
}
