"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const app_module_1 = require("./app.module");
const helmet_1 = require("helmet");
const cookieParser = require("cookie-parser");
const express_1 = require("express");
const express_rate_limit_1 = require("express-rate-limit");
const common_1 = require("@nestjs/common");
const dotenv = require("dotenv");
const logger_1 = require("./shared/logger");
const http_exception_filter_1 = require("./shared/filters/http-exception.filter");
const path = require("path");
dotenv.config();
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule, { logger: new logger_1.Logger() });
    app.set('trust proxy', 1);
    const origins = process.env.CORS_ORIGINS?.split(',').map(o => o.trim()).filter(o => o) || [];
    app.enableCors({
        origin: origins.length > 0 ? origins : true,
        credentials: true,
        methods: 'GET,HEAD,PUT,PATCH,POST,DELETE,OPTIONS',
        allowedHeaders: 'Content-Type, Accept, Authorization, x-access-token, Origin, X-Requested-With',
    });
    app.use((0, helmet_1.default)({
        crossOriginResourcePolicy: { policy: 'cross-origin' },
    }));
    app.use(cookieParser());
    app.use('/uploads', (0, express_1.static)(path.join(process.cwd(), 'uploads')));
    app.use((0, express_1.json)({ limit: '5mb' }));
    app.use((0, express_1.urlencoded)({ extended: true, limit: '5mb' }));
    app.useGlobalPipes(new common_1.ValidationPipe({
        whitelist: true,
        transform: true,
    }));
    app.useGlobalFilters(new http_exception_filter_1.HttpExceptionFilter());
    app.use((0, express_rate_limit_1.default)({
        windowMs: 60 * 1000,
        max: 100,
    }));
    const port = process.env.PORT || 8181;
    await app.listen(port);
    console.log(`Server started on http://localhost:${port}`);
}
bootstrap();
//# sourceMappingURL=main.js.map