"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const configuration_1 = require("./config/configuration");
const mongoose_1 = require("@nestjs/mongoose");
const auth_module_1 = require("./modules/auth/auth.module");
const users_module_1 = require("./modules/users/users.module");
const specialities_module_1 = require("./modules/specialities/specialities.module");
const retraining_module_1 = require("./modules/retraining/retraining.module");
const welfare_module_1 = require("./modules/welfare/welfare.module");
const board_members_module_1 = require("./modules/board-members/board-members.module");
const news_module_1 = require("./modules/news/news.module");
const notifications_module_1 = require("./modules/notifications/notifications.module");
const events_module_1 = require("./modules/events/events.module");
const passport_1 = require("@nestjs/passport");
const shared_module_1 = require("./shared/shared.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({ isGlobal: true, load: [configuration_1.default] }),
            mongoose_1.MongooseModule.forRoot(process.env.MONGO_URI || 'mongodb://localhost:27017/pwa'),
            passport_1.PassportModule.register({ session: false }),
            shared_module_1.SharedModule,
            auth_module_1.AuthModule,
            users_module_1.UsersModule,
            specialities_module_1.SpecialitiesModule,
            retraining_module_1.RetrainingModule,
            welfare_module_1.WelfareModule,
            board_members_module_1.BoardMembersModule,
            news_module_1.NewsModule,
            notifications_module_1.NotificationsModule,
            events_module_1.EventsModule,
        ],
        providers: [],
        exports: [],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map